{http://www.latiumsoftware.com/en/delphi/00003.php}
unit ExecAndWait;

interface
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;


function _ExecAndWait(ExecFile:PChar) :Boolean;

implementation

function _ExecAndWait(ExecFile:PChar) :Boolean;
var
  proc_info: TProcessInformation;
  startinfo: TStartupInfo;
begin
  //ShowMessage(ExecFile);

  // Initialize the structures
  FillChar(proc_info, sizeof(TProcessInformation), 0);
  FillChar(startinfo, sizeof(TStartupInfo), 0);
  startinfo.cb := sizeof(TStartupInfo);

  // Attempts to create the process
  //if CreateProcess(ExecFile, nil, nil, nil, false, NORMAL_PRIORITY_CLASS, nil, nil, startinfo, proc_info) <> False then
  if CreateProcess(nil, ExecFile, nil, nil, false, NORMAL_PRIORITY_CLASS, nil, nil, startinfo, proc_info) <> False then
  begin
    // The process has been successfully created
    // No let's wait till it ends...
    WaitForSingleObject(proc_info.hProcess, INFINITE);
    // Process has finished. Now we should close it.
    CloseHandle(proc_info.hProcess);
    //Application.MessageBox('Notepad finished!','Info', MB_ICONINFORMATION);
    Result:=True;
  end
  else
  begin
    // Failure creating the process
    //Application.MessageBox('Couldn''t execute the ' + 'application', 'Error', MB_ICONEXCLAMATION);
    Result:=false;
  end;//if
end;


end.
